#define GDEV_GB_ID				(0)
#define GDEV_GD_ID				(1)
#define GDEV_GS_ID				(2)
#define GDEV_SGB_ID				(3)
#define GDEV_SGD_ID				(4)

#define GDEV_SGT_MEM_OK				(1)
#define GDEV_OK						(0)
#define GDEV_ERR_MEM_OPEN_MAP		(0)
#define GDEV_ERR_DEV_NAME_ID		(-1)
#define GDEV_ERR_DEV_NUM_MIN		(-2)
#define GDEV_ERR_DEV_NUM_MAX		(-3)
#define GDEV_ERR_DEV_NUM			(-4)
#define GDEV_ERR_DEV_VALUE_TABLE	(-5)
#define GDEV_ERR_DEV_VALUE			(-6)
#define GDEV_ERR_MAP_POINTER		(-9)
#define GDEV_ERR_DATASIZE			(-10)
#define GDEV_ERR_DEV_INFO			(-11)

#ifndef WINAPI
	#define WINAPI
#endif

typedef struct _STMAPINFO{
	HANDLE			hMapFile;
	unsigned long	ulMapPointer;
}STMAPINFO, *LPSTMAPINFO;

typedef struct _STDEVINFO{
	long			lDevNameID;
	long			lDevNum;
	long*			lplDataValue;
	long			lError;
}STDEVINFO, *LPSTDEVINFO;

extern "C" {
	unsigned long	WINAPI	GDev_OpenMapping(
									HANDLE			*lphMapFile,
									short			sGotNo
							);

	void			WINAPI	GDev_CloseUnMapping(
									HANDLE			hMapFile,
									unsigned long	ulMapPointer
							);

	long			WINAPI	GDev_Read(
									unsigned long	ulMapPointer,
									short			sDevNameID,
									long			lDevNum,
									short			*lpsDataTable,
									long			lDataSize
							);

	long			WINAPI	GDev_Write(
									unsigned long	ulMapPointer,
									short			sDevNameID,
									long			lDevNum,
									short			*lpsDataTable,
									long			lDataSize
							);

	long			WINAPI	sgt_GDevOpenMapping(
									STMAPINFO		*lpstMapInfo,
									short			sGotNo
							);

	void			WINAPI	sgt_GDevCloseUnMapping(
									STMAPINFO		*lpstMapInfo
							);

	long			WINAPI	sgt_ReadDeviceRandom(
									STMAPINFO		*lpstMapInfo,
									STDEVINFO		*lpstDevInfo,
									long			lDataSize
							);

	long			WINAPI	sgt_WriteDeviceRandom(
									STMAPINFO		*lpstMapInfo,
									STDEVINFO		*lpstDevInfo,
									long			lDataSize
							);

	long			WINAPI	sgt_ReadDeviceBlock(
									STMAPINFO		*lpstMapInfo,
									STDEVINFO		*lpstDevInfo,
									long			lDataSize
							);

	long			WINAPI	sgt_WriteDeviceBlock(
									STMAPINFO		*lpstMapInfo,
									STDEVINFO		*lpstDevInfo,
									long			lDataSize
							);
}
